elseif ($aksi == 'edit') {

    $id         = $_POST['id'];
    $no_anggota = trim($_POST['no_anggota']);
    $nama       = trim($_POST['nama']);
    $alamat     = trim($_POST['alamat']);
    $no_hp      = trim($_POST['no_hp']);

    if ($id == '' || $no_anggota == '' || $nama == '' || $alamat == '' || $no_hp == '') {
        $_SESSION['error'] = "Semua field wajib diisi";
        header("Location: ../modules/anggota/edit.php?id=$id");
        exit;
    }

    $stmt = $db->prepare(
        "UPDATE anggota SET no_anggota=?, nama=?, alamat=?, no_hp=? WHERE id=?"
    );
    $stmt->bind_param("ssssi", $no_anggota, $nama, $alamat, $no_hp, $id);

    if ($stmt->execute()) {
        $_SESSION['success'] = "Data anggota berhasil diperbarui";
        header("Location: ../modules/anggota/index.php");
    } else {
        $_SESSION['error'] = "Gagal memperbarui data";
        header("Location: ../modules/anggota/edit.php?id=$id");
    }

    $stmt->close();
}
/*
|--------------------------------------------------------------------------
| PROSES UPDATE ANGGOTA
|--------------------------------------------------------------------------
*/
if (isset($_POST['update'])) {

    $id         = intval($_POST['id']);
    $no_anggota = trim($_POST['no_anggota']);
    $nama       = trim($_POST['nama']);
    $alamat     = trim($_POST['alamat']);
    $status     = $_POST['status'];

    if ($no_anggota === '' || $nama === '' || $alamat === '') {
        $_SESSION['error'] = 'Semua data wajib diisi';
        header("Location: ../modules/anggota/edit.php?id=".$id);
        exit;
    }

    $stmt = $conn->prepare("
        UPDATE anggota
        SET no_anggota=?, nama=?, alamat=?, status=?
        WHERE id=?
    ");
    $stmt->bind_param("ssssi", $no_anggota, $nama, $alamat, $status, $id);

    if ($stmt->execute()) {
        $_SESSION['success'] = 'Data anggota berhasil diperbarui';
        header("Location: ../modules/anggota/index.php");
        exit;
    } else {
        $_SESSION['error'] = 'Gagal memperbarui data';
        header("Location: ../modules/anggota/edit.php?id=".$id);
        exit;
    }
}
